/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;

public class TaskCheckMediaSense
extends Task {
    private String m_regKey = "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\Tcpip\\Parameters";
    private String m_regValName = "DisableDHCPMediaSense";
    private String m_regKeyW2k3 = "HKEY_LOCAL_MACHINE\\Cluster\\Parameters";
    private String m_regValNameW2k3 = "DisableClusSvcMediaSense";
    private ClusterWindows clusterWindows = null;

    public TaskCheckMediaSense(String[] nodeList) {
        super(nodeList);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean performTask() {
        boolean result = false;
        boolean osW2k3Scenario = false;
        boolean enabledDHCPOSW2k3 = false;
        int keyValueData = 0;
        ResultSet msResultSet = new ResultSet();
        String errMsg = null;
        String osName = DeterminePlatform.getOSName();
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("4140", false));
        Trace.out((String)"TaskCheckMediaSense :: Performing Media Sense verification task for Windows... ");
        try {
            this.clusterWindows = new ClusterWindows();
        }
        catch (ClusterException e) {
            Trace.out((String)("TaskCheckMediaSense:: Cannot create ClusterWindows " + e.getMessage()));
            errMsg = s_msgBundle.getMessage("4142", true);
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        Trace.out((String)"TaskCheckMediaSense:: Performing Media Sense verification ...");
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            block25: {
                block24: {
                    osW2k3Scenario = false;
                    enabledDHCPOSW2k3 = false;
                    if (!osName.equalsIgnoreCase("Windows 2003")) break block24;
                    try {
                        result = this.clusterWindows.regKeyExistsOnNode(this.m_regKeyW2k3, this.m_nodeList[i]);
                    }
                    catch (ClusterException ce) {
                        Trace.out((String)("TaskCheckMediaSense:: Could not read Registry subkey " + this.m_regKeyW2k3 + " error : " + ce.getMessage()));
                        errMsg = s_msgBundle.getMessage("4146", true);
                        msResultSet.addErrorDescription(this.m_nodeList[i], new ErrorDescription(errMsg));
                        msResultSet.addResult(this.m_nodeList[i], 2);
                        continue;
                    }
                    if (result) {
                        osW2k3Scenario = true;
                        try {
                            keyValueData = this.clusterWindows.getRegIntegerDataOnNode(this.m_regKeyW2k3, this.m_regValNameW2k3, this.m_nodeList[i]);
                        }
                        catch (ClusterException e) {
                            Trace.out((String)("TaskCheckMediaSense:: Registry Value " + this.m_regValNameW2k3 + " not found under subkey " + this.m_regKeyW2k3 + " error : " + e.getMessage()));
                            errMsg = s_msgBundle.getMessage("4148", true);
                            msResultSet.addErrorDescription(this.m_nodeList[i], new ErrorDescription(errMsg));
                            msResultSet.addResult(this.m_nodeList[i], 2);
                            continue;
                        }
                        if (keyValueData == 0) {
                            msResultSet.addResult(this.m_nodeList[i], 1);
                            continue;
                        }
                        if (keyValueData == 1) {
                            enabledDHCPOSW2k3 = true;
                        }
                        break block25;
                    } else {
                        msResultSet.addResult(this.m_nodeList[i], 1);
                        continue;
                    }
                }
                osW2k3Scenario = false;
            }
            if (!osW2k3Scenario || enabledDHCPOSW2k3) {
                result = false;
                try {
                    result = this.clusterWindows.regKeyExistsOnNode(this.m_regKey, this.m_nodeList[i]);
                }
                catch (ClusterException ce) {
                    Trace.out((String)("TaskCheckMediaSense:: Could not read Registry subkey " + this.m_regKey + " error : " + ce.getMessage()));
                    errMsg = s_msgBundle.getMessage("4145", true);
                    msResultSet.addErrorDescription(this.m_nodeList[i], new ErrorDescription(errMsg));
                    msResultSet.addResult(this.m_nodeList[i], 2);
                    continue;
                }
                if (result) {
                    try {
                        keyValueData = this.clusterWindows.getRegIntegerDataOnNode(this.m_regKey, this.m_regValName, this.m_nodeList[i]);
                    }
                    catch (ClusterException e) {
                        Trace.out((String)("TaskCheckMediaSense:: Registry value " + this.m_regValName + " not found under Reg Subkey " + this.m_regKey + " error : " + e.getMessage()));
                        errMsg = s_msgBundle.getMessage("4147", true);
                        msResultSet.addErrorDescription(this.m_nodeList[i], new ErrorDescription(errMsg));
                        msResultSet.addResult(this.m_nodeList[i], 3);
                        continue;
                    }
                    if (keyValueData == 1) {
                        msResultSet.addResult(this.m_nodeList[i], 1);
                        continue;
                    }
                    msResultSet.addResult(this.m_nodeList[i], 3);
                    Trace.out((String)("TaskCheckMediaSense:: The Registry Value data for " + this.m_regValName + " is : " + keyValueData));
                    continue;
                }
                msResultSet.addResult(this.m_nodeList[i], 2);
                continue;
            }
            msResultSet.addResult(this.m_nodeList[i], 2);
        }
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, s_msgBundle.getMessage("5207", false), ReportUtil.COMMENT);
        this.m_resultSet.uploadResultSet(msResultSet);
        Hashtable ht = this.m_resultSet.getResultTable();
        Enumeration e = ht.keys();
        Hashtable mediaSenseList = new Hashtable();
        Vector<String> verFailedNodes = new Vector<String>();
        Vector<String> opFailedNodes = new Vector<String>();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result msResult = (Result)ht.get(node);
            if (msResult.getStatus() == 1) {
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(s_msgBundle.getMessage("8134", false));
                this.m_resultSet.getResult(node).setActualValue(s_msgBundle.getMessage("8134", false));
                Trace.out((String)("Result.OPERATION_SUCCESSFUL:: Media Sense is Disabled on Node " + node));
                ReportUtil.writeRecord(node, ReportUtil.NO, ReportUtil.PASSED);
                continue;
            }
            if (msResult.getStatus() == 3) {
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(s_msgBundle.getMessage("8134", false));
                this.m_resultSet.getResult(node).setActualValue(s_msgBundle.getMessage("8133", false));
                Trace.out((String)("Result.VERIFICATION_FAILED:: Media Sense is Enabled on Node " + node));
                ReportUtil.writeRecord(node, ReportUtil.YES, ReportUtil.FAILED);
                verFailedNodes.add(node);
                continue;
            }
            Trace.out((String)"Result.OPERATION FAILED:: cannot perform Media Sense check");
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, ReportUtil.FAILED);
            opFailedNodes.add(node);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("4141", false));
            return true;
        }
        if (verFailedNodes.size() > 0) {
            ReportUtil.printError(s_msgBundle.getMessage("4143", true));
            ReportUtil.sureprintNodelist(verFailedNodes);
        }
        if (opFailedNodes.size() > 0) {
            ReportUtil.printError(s_msgBundle.getMessage("4144", true));
            ReportUtil.sureprintNodelist(opFailedNodes);
        }
        return false;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4149", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4139", false);
    }
}

